from django.db import models
from django.contrib.auth.models import User
from datetime import datetime

# Create your models here.


class Tasks(models.Model):

    name = models.CharField(max_length=100, blank=False, null=False)
    description = models.TextField(max_length=500, blank=False, null=False)
    timestamp = models.DateTimeField(auto_now_add=True)
    assigned_user = models.ForeignKey(User, null=True, on_delete=models.SET_NULL)

    def save(self, *args, **kwargs):
        self.timestamp = datetime.now()
        super().save(*args, **kwargs)

    def __str__(self):
        return "{name}: {timestamp}".format(
            name=self.name,
            timestamp=self.timestamp
        )
