from rest_framework import serializers
from .models import *

from django.contrib.auth.models import User


class UserSerializer(serializers.ModelSerializer):

    class Meta:
        model = User
        fields = ['username', 'email']

class TasksSerializer(serializers.ModelSerializer):

    assigned_user_data = UserSerializer(source="assigned_user", read_only=True)

    class Meta:
        model = Tasks
        fields = ['id', 'name', 'description', 'assigned_user', 'assigned_user_data']

