from django.shortcuts import render
from django.http import HttpResponse
from django.views import View

from rest_framework.views import APIView
from rest_framework.response import Response
from rest_framework import status, permissions

from .models import Tasks
from .serializers import TasksSerializer

# Create your views here.

class todoListApiDetailView(APIView):

    def get(self, request, id=None):

        tasks_object = Tasks.objects.filter(id=id)

        tasks_object_serializer = TasksSerializer(tasks_object, many=True)

        return Response(tasks_object_serializer.data, status.HTTP_200_OK)

    def put(self, request, id=None):

        tasks_object = Tasks.objects.filter(id=id)

        if not tasks_object:
            return Response([], status=status.HTTP_404_NOT_FOUND)

        tasks_serializer = TasksSerializer(tasks_object[0], data=request.data, partial=True)

        print('tasks_serializer', tasks_serializer)

        if tasks_serializer.is_valid():
            tasks_serializer.save()

            return Response(tasks_serializer.data, status.HTTP_200_OK)

        return Response(tasks_serializer.errors, status.HTTP_400_BAD_REQUEST)


    def delete(self, request, id=None):

        tasks_object = Tasks.objects.filter(id=id)

        if tasks_object:
            tasks_object.delete()

            return Response([], status=status.HTTP_200_OK)

        return Response([], status=status.HTTP_404_NOT_FOUND)


class todolistApiView(APIView):
    permission_classes = [permissions.IsAuthenticated]


    def get(self, request, *args, **kwargs):

        assigned_user = request.GET.get('assigned_user', False)
        if assigned_user:
            all_tasks = Tasks.objects.filter(assigned_user=assigned_user)
        else:
            all_tasks = Tasks.objects.filter()

        all_tasks_serializer = TasksSerializer(all_tasks, many=True)

        return Response(all_tasks_serializer.data, status.HTTP_200_OK)

    def post(self, request, *args, **kwargs):

        name = request.data.get('name', False)
        description = request.data.get('description', False)
        assigned_user = request.data.get('assigned_user', None)

        if not name:
            Response('Send name as a body value', status.HTTP_204_NO_CONTENT)

        if not description:
            Response('Send description as a body value', status.HTTP_204_NO_CONTENT)

        data = {
            'name': name,
            'description': description,
            'assigned_user': assigned_user
        }

        data_serialized = TasksSerializer(data=data)

        if data_serialized.is_valid():
            data_serialized.save()

            return Response(data_serialized.data, status.HTTP_201_CREATED)

        return Response(data_serialized.errors, status.HTTP_400_BAD_REQUEST)
