
import requests
from bs4 import BeautifulSoup

def request_web_content(url: str) -> str:

    response = requests.get(url)

    if response.status_code == 200:
        return response.content
    else:
        return ''

def parse_html(html: str) -> str:

    try:
        soup = BeautifulSoup(html, 'html.parser')
    except Exception as e:
        raise NameError('Invalid html')

    return soup

def find_in_html(html, filter: str, class_: str = None) -> any:

    results = html.find(
        filter, class_=class_
    )

    return results

def find_all(html, filter: str) -> any:

    results = html.find_all(filter)

    return results

def get_text(element) -> str:

    return element.text

def get_href_text(element) -> str:

    return element.get('href')
