import re

from config import CONFIGURATION
import core.translator as translator

from core.speech import speech
from core.voice_recognition import recognize

from anydo_api.client import Client
from anydo_api.task import Task
from anydo_api.category import Category

# Login to anydo
any_do_user = Client(email=CONFIGURATION['anydo']['user'], password=CONFIGURATION['anydo']['password']).get_user()

def viewTasks(text: str) -> None:
    tasks = any_do_user.tasks()

    for task in tasks:
        print(task['title'], task.status)
        if task.status == 'UNCHECKED':
            speech(translator.translate_text(task['title']))

    return None

def createTasks(text: str, options_create_tasks: list) -> bool:

    title = ''
    priority = ''
    category = ''
    repeating_method = ''

    categories = any_do_user.categories()
    categories_text = list(map(lambda category: category['name'], any_do_user.categories()))
    categories_text.insert(len(categories_text) - 1, 'o')
    categories_text = ', '.join(
        categories_text
    )

    # Get title
    for option in options_create_tasks:
        if re.match(option, text):
            if option.count('.*') > 1:
                first_prefix = option.split('.*')[0].replace('^', '')
                second_prefix = option.split('.*')[1].replace('^', '')

                title = text.split(first_prefix)[1]
                title = title.split(second_prefix)[0]
            else:

                first_prefix = option.split('.*')[0].replace('^', '')

                title = text.split(first_prefix)[1]

    # speech(translator.translate_text('¿La prioridad de la tarea es alta o normal?'))
    # while priority == '': 
    #     priority = recognize()
    #     if len(priority) == 0:
    #         speech(translator.translate_text('No entendi, ¿podrias repetirlo?'))
    #     if priority in ['cancelar', 'cancelalo', 'no lo guardes']:
    #         return True
    #     elif priority in ['sin prioridad']:
    #         priority = ''
    #         break

    speech(translator.translate_text('¿En que categoria la guardo?'))
    speech(categories_text)
    while category == '': 
        category = recognize(CONFIGURATION['anydo']['lang'])
        print(categories_text, category)
        if len(category) == 0 or categories_text.lower().count(category) == 0:
            speech(translator.translate_text('No entendi, ¿podrias repetirlo?'))

        if category in ['cancelar', 'cancelalo', 'no lo guardes']:
            return True
        elif category in ['sin categoria']:
            category = ''
            break
        elif category != '':
            # Set category as default
            for user_category in categories:
                if category in user_category['name'].lower():
                    user_category.mark_default()


    # speech(translator.translate_text('La tarea se repetira?'))
    # while repeating_method == '': 
    #     repeating_method = recognize()
    #     if len(repeating_method) == 0:
    #         speech(translator.translate_text('No entendi, ¿podrias repetirlo?'))
    #     if repeating_method in ['cancelar', 'cancelalo', 'no lo guardes']:
    #         return True

    try:
        task = Task.create(
                    user=any_do_user,
                    title=title,
                    priority=priority,
                    category=category,
                    repeatingMethod='TASK_REPEAT_ON' if repeating_method == 'sí' else 'TASK_REPEAT_OFF'
                )
        speech(translator.translate_text('Tarea creada con exito'))
    except Exception as e:
        speech(translator.translate_text('No pude guardar la tarea'))

        return False

    return True

def isAnydo(text: str) -> bool:
    # View tasks
    options_view_tasks = ["qué hay en mi lista de", "qué tengo que hacer hoy", "tengo algo que hacer"]
    for option in options_view_tasks:
        if option in text:
            viewTasks(text)

            return True

    options_create_tasks = ["^añadir.*a mi lista de.*", "^añade.*mi lista de.*","^añade.*a mi lista de.*", "^agrega.*en mi lista de.*", "^pon.*en mi lista de.*", "^recuérdame.*", "^acuérdame.*"]
    for option in options_create_tasks:
        if re.match(option, text):
            createTasks(text, options_create_tasks)

            return True

    return False