from config import CONFIGURATION
import core.translator as translator

import core.scrapper as scrapper

from core.speech import speech
from core.voice_recognition import recognize

import gbmplus

def get_client_id() -> any:

    html = scrapper.request_web_content(CONFIGURATION['gbm_plus']['url'])

    try:
        html_obtained = scrapper.parse_html(html)
    except Exception as e:
        speech(translator.translate_text('No se pudo conectar a gbm plus'))
        return True

    div_element = scrapper.find_in_html(html_obtained, 'div', 'elementor-heading-title elementor-size-default')

    a_element = scrapper.find_all(div_element, 'a')

    href_element = scrapper.get_href_text(a_element[0])

    client_id = href_element.split('client_id=')[1]

    return client_id

gbm = gbmplus.GBMPlusAPI(
    client_id = get_client_id(),
    user_email = CONFIGURATION['gbm_plus']['USER_EMAIL'],
    user_password = CONFIGURATION['gbm_plus']['USER_PASSWORD'],    
    output_log=False,
    print_console=False
)
print('[!] GBM logged')

def get_accounts() -> str:

    accounts = gbm.accounts.getAccounts()
    accounts_dict = {element["name"]: element for element in accounts}

    return accounts_dict

def getGBMInformation(text: str) -> bool:

    accounts_dict = get_accounts()

    for account in accounts_dict:
        label = account
        account_props = accounts_dict[label]

        speech(translator.translate_text('En {name} tienes {amount} {currency} con un rendimiento de {gain} {gain_currency}').format(
            name=label,
            amount=account_props['position']['amount'],
            currency=calculate_currency(account_props['position']['currency']),
            gain=account_props['plus_minus']['amount'],
            gain_currency=calculate_currency(account_props['plus_minus']['currency']),
        ))

def calculate_currency(currency) -> str:
    
    if currency == 'MXN':
        return 'pesos'
    elif currency == 'USD':
        return 'dolares'

def isGBM(text: str) -> bool:
    options = ["gbm", "gbm plus"]

    for option in options:
        if option in text:
            getGBMInformation(text)
            return True

    return False
