from config import CONFIGURATION
import core.translator as translator

from core.speech import speech

import datetime
import calendar
import locale
import re

locale.setlocale(locale.LC_TIME, "es_ES")

def actualTime(text: str) -> None:
    response = ""

    options_time = ["hora", "tiempo"]

    for option in options_time:
        if option in text:
            actualTimeStrHour = datetime.datetime.now().strftime("%I")
            actualTimeStrMinute = datetime.datetime.now().strftime("%M")
            actualTimeStrSecond = datetime.datetime.now().strftime("%S")
            actualTimeStrAmpm = datetime.datetime.now().strftime("%p")

            response = "{prefix} {hour} {minute} con {seconds} segundos {ampm}".format(
                prefix=translator.translate_text("Es la") if int(actualTimeStrHour) == 1 else translator.translate_text("Son las"),
                hour=translator.translate_text("una") if int(actualTimeStrHour) == 1 else int(actualTimeStrHour),
                minute=int(actualTimeStrMinute),
                seconds=int(actualTimeStrSecond),
                ampm="{first} {second}".format(
                    first=actualTimeStrAmpm.upper()[0],
                    second=actualTimeStrAmpm.upper()[1],
                ),
            )

    options_time_complete = ["dia", "día"]

    for option in options_time_complete:
        if option in text:
            actualTimeStr = datetime.datetime.now().strftime("%A %d de %B")
            response = "{prefix} {time}".format(
                prefix=translator.translate_text('Hoy es'),
                time=actualTimeStr
            )

    speech(response)

    return None

def fortnightTime(text: str) -> None:

    options_fortnight = ["^.*falta.*para.*(quincena|15).*$", "^.*día (es|cae) (quincena|15)$"]
    for i in range(len(options_fortnight)):
        option = options_fortnight[i]
        print(i, option)
        if re.match(option, text):
            if i == 0:

                current_day = int(datetime.datetime.now().strftime("%d"))

                if current_day <= 15:


                    if (15 - current_day) == 0:
                        speech(translator.translate_text('Hoy es quincena'))

                    else:

                        speech(translator.translate_text('Faltan {days} días para que sea quincena').format(
                            days=15 - current_day
                        ))

                else:

                    current_time = datetime.datetime.now()
                    total_days_in_month = calendar.monthrange(current_time.year, current_time.month)[1]

                    if (int(total_days_in_month) - current_day) == 0:

                        speech(translator.translate_text('Hoy es quincena'))

                    else:

                        speech(translator.translate_text('Faltan {days} días para que sea quincena').format(
                            days=int(total_days_in_month) - current_day
                        ))

            elif i == 1:

                current_year = int(datetime.datetime.now().strftime("%Y"))
                current_month = int(datetime.datetime.now().strftime("%m"))
                current_day = int(datetime.datetime.now().strftime("%d"))

                if current_day <= 15:

                    fortnight_day = datetime.datetime(year=current_year, month=current_month, day=15)

                    speech(translator.translate_text('el día {day}').format(
                        day=fortnight_day.strftime("%A")
                    ))

                else:

                    current_time = datetime.datetime.now()
                    total_days_in_month = calendar.monthrange(current_time.year, current_time.month)[1]

                    fortnight_day = datetime.datetime(year=current_year, month=current_month, day=total_days_in_month)

                    speech(translator.translate_text('el día {day}').format(
                        day=fortnight_day.strftime("%A")
                    ))

    return None

def isTime(text: str) -> bool:
    options = ["hora", "tiempo", "qué dia", "qué día"]
    for option in options:
        if option in text:
            actualTime(text)
            return True

    options_fortnight = ["^.*falta.*para.*(quincena|15).*$", "^.*día (es|cae) (quincena|15)$"]
    for option in options_fortnight:
        if re.match(option, text):
            fortnightTime(text)
            return True

    return False
