from config import CONFIGURATION
import core.translator as translator

from core.speech import speech
from core.voice_recognition import recognize

import webbrowser
import re

from pytube import Search

def getUrlFirstVideo(text: str, options_search_video: str) -> str:

    # Get search query
    for option in options_search_video:
        if re.match(option, text):
            first_prefix = option.split('.*')[0].replace('^', '')
            second_prefix = option.split('.*')[1].replace('^', '')

            search_query = text.split(first_prefix)[1]
            search_query = search_query.split(second_prefix)[0].replace(' ', '%20')


    all_video_results = Search(search_query)

    try:
        for x in all_video_results.results:
            print(x.watch_url)
        # print(all_video_results.results[0].watch_url)
    except Exception as e:
        print(e)

    return [search_query, all_video_results.results[0].watch_url]

def searchVideo(text: str, options_search_video: str) -> bool:

    search_query, video_url = getUrlFirstVideo(text, options_search_video)

    try:
        speech(translator.translate_text('Abriendo {search_query} en youtube').format(
            search_query=search_query.replace('%20', ' ')
        ))
        webbrowser.open_new_tab(video_url)
    except Exception as e:
        return False
    
    return True


def isWebbrowser(text: str) -> bool:

    options_search_video = ["^busca.*en youtube.*", "^abre.*en youtube.*"]
    for option in options_search_video:
        if re.match(option, text):
            searchVideo(text, options_search_video)

            return True

    return False