from config import CONFIGURATION
import core.translator as translator

import wikipedia

wikipedia.set_lang(CONFIGURATION['language']['lang'])

from core.speech import speech


def search(text: str) -> None:
    text = text.replace('wikipedia', '')
    try:
        results = wikipedia.summary(text, sentences=1)
        speech('{prefix} {text}'.format(
            prefix=translator.translate_text('Segun wikipedia'),
            text=results
            )
        )
    except Exception as e:
        results = translator.translate_text('No he encontrado la información')
        speech(results)

    return None

def isWikipedia(text: str) -> bool:
    if 'wikipedia' in text:
        search(text)

        return True

    return False
