from config import CONFIGURATION
import core.translator as translator

from core.speech import speech


def welcome() -> None:
    speech(
        text="{prefix} {name}".format(
            prefix=translator.translate_text('Bienvenido'),
            name=CONFIGURATION["user"]["name"]
        )
    )

    return None

def greeting(text: str) -> None:
    speech(
        "Soy tu asistente virtual, fui creada por {name}. Me falta mucho por crecer.".format(
            name=CONFIGURATION["user"]["name"],
            last_name=CONFIGURATION["user"]["last_name"],
        )
    )

    return None


def hello() -> None:
    speech("Hola")

    return None


def goodbye() -> None:
    speech("Adiós")
    exit()


def itsMe(text: str) -> bool:
    who_am_i = [
        "quién eres tu",
        "quién eres",
        "como te llamas",
        "identificate",
        "que eres",
    ]
    for option in who_am_i:
        if option in text:
            greeting(text)
            return True

    if "hola" in text:
        hello()
        return True

    end_options = ["adiós", "apagate", "cierrate"]
    for option in end_options:
        if option in text:
            goodbye()
            return True

    return False
