from config import CONFIGURATION

import os
from gtts import gTTS, lang
from playsound import playsound

# Text to audio
def speech(text: str, lang: str=CONFIGURATION['language']['lang'], tld: str=CONFIGURATION['language']['tld']) -> None:
    try:
        speech = gTTS(text=text, lang=lang, tld=tld)
        speech.save('_speech.mp3')

        playsound('./_speech.mp3')

    except Exception as e:
        playsound('./_speech_error.mp3')

    finally:
        os.remove('_speech.mp3')

    return None
