from .speech import speech
from config import CONFIGURATION

import speech_recognition as sr


def recognize(lang: str = None) -> str:
    r = sr.Recognizer()
    with sr.Microphone() as source:
        print("[!] Listening user")
        audio = r.listen(source)

        try:

            statement = r.recognize_google(audio, language=CONFIGURATION['language']['lang'] if lang == None else lang)

        except Exception as e:
            print("[-] Text not recognized")

            # speech("Disculpa {name}, no entendi lo que dijiste.".format(name=CONFIGURATION["user"]["name"]))
            # speech("Excuse me, I dont understand what you said")
            return ""

        print("[+] Text recognized")
        return statement
