# Core
from config import CONFIGURATION
import core.spectra as spectra
import core.translator as translator

# Speech recognition and voice speak
from core.speech import speech
from core.voice_recognition import recognize

# Skills
import core.skill.wikipedia as wikipedia
import core.skill.time as time
import core.skill.anydo as anydo
# import core.skill.gbm_plus as gbm_plus
import core.skill.web_browser as web_browser

def core() -> None:
    spectra.welcome()

    while True:
        statement = recognize()

        if len(statement) > 0:

            statement = translator.translate_text(statement).lower()

            spectraEnabled = spectra.itsMe(statement)
            if spectraEnabled:
                continue
            wikipediaEnabled = wikipedia.isWikipedia(statement)
            if wikipediaEnabled:
                continue
            timeEnabled = time.isTime(statement)
            if timeEnabled:
                continue
            anydoEnabled = anydo.isAnydo(statement)
            if anydoEnabled:
                continue
            # gbm_plusEnabled = gbm_plus.isGBM(statement)
            # if gbm_plusEnabled:
            #     continue
            web_browserEnabled = web_browser.isWebbrowser(statement)
            if web_browserEnabled:
                continue


            print("{prefix} {text}".format(
                    prefix=translator.translate_text('Dijiste'),
                    text=statement
                )
            )

        continue


if __name__ == "__main__":
    core()
    # web_browser.isWebbrowser('busca videos de perritos en youtube')